#ifndef _GAMELOGIC
#define _GAMELOGIC
#include "main.h"
using namespace std;

#define C_EDGE_BORDER 60

class PlotEntry
{
public:

	CL_Vector2 m_pos;
};

typedef vector<PlotEntry> plotVec;

class PlotManager
{
public:

	void Plot(CL_Rect r, int count, float sinPower);
	plotVec m_plotVec;
};


#pragma once

#include "main.h"
#include "MyEntityManager.h"
#include "MessageDispatcher.h"

class EntPlayer;
class Message;


enum
{
  C_SOUND_BEE,
  C_SOUND_TOO_SLOW,
  C_SOUND_SQUISH,
  C_SOUND_START,
  C_SOUND_RIFF,
  C_SOUND_INTRO,
  C_SOUND_POWERUP,
  C_SOUND_WONDERBOY,

     C_SOUND_COUNT
	 

};


class GameLogic
{

public:


    GameLogic();
    ~GameLogic();

      bool Init();
      
      void Update(float step);
      void Render();
      void RebuildBuffers();
      MyEntityManager * GetMyEntityManager() {return &m_myEntityManager;}
      void Kill();
      void DrawGUI();
      void Play(int soundID) {m_sounds[soundID]->play();}
      void OnMessage(Message &msg);
      MessageDispatcher * GetMessageDispatcher(){return &m_messageDispatcher;}
      bool ShuttingDown() {return m_sounds[0] == NULL;} //ents will crash if they don't know we're shutting down
      void ResetGame();
	  void SetupFlies();
	  void CalculateSwipeScore();
	  void SetupLevelData(int day);
	
		enum
		{

			C_SPACE_NOTHING,
			C_SPACE_TO_HELP,
			C_SPACE_START_GAME,
		};

	  int m_spaceFunctionality;

	  int m_fliesKilled;
	  int m_wavesLeft;
	  int m_scoreThisRound;

private:

	void RenderGUI();
	void ResetTimer();

    void OnKeyDown(const CL_InputEvent &key);
    MyEntityManager m_myEntityManager;
    CL_Slot m_slotKeyDown;
    EntPlayer *m_pPlayer; //remember where he's at
    CL_SoundBuffer *m_sounds[C_SOUND_COUNT];
    MessageDispatcher m_messageDispatcher;
	int m_barTimer;
	int m_textTimer;
	int m_timeAllowed;
    std::string m_textMessage;
	int m_totalScore;
	int m_lastSwipeScore;
	float m_barFreeze;
	int m_day;

	CL_Rect m_flyRect;
	float m_sinMin;
	float m_sinMax;
	//the level data
	int m_countMin;
	int m_countMax;
	int m_fliesSpawned;
	string m_levelText;
	int m_scoreRequired;
	string m_bg;
	float m_failMod;
	
 };

#define GetGameLogic GetApp()->GetGameLogic()
#define GetMyEntityMgr GetGameLogic->GetMyEntityManager()

extern PlotManager g_plotManager;

void GetRandomPosition(CL_Vector2 &v);
#endif