#include "Fly.h"
#include "GameLogic.h"

Fly::Fly()
{
	SetType(C_TYPE_FLY);
	m_sprite = new CL_Sprite("fly", GetApp()->GetResourceManager());

	
	m_vPosition.x = Random(1000);
	m_vPosition.y = Random(600);
	m_mode = eWaiting;
}

Fly::~Fly()
{
	
}

void Fly::OnMessage(Message &msg)
{
	switch(msg.m_msg)
	{
	case C_MESSAGE_KILL_FLIES:

			//fly away or do something cool
			m_mode = eLeaving;
			m_bFadeAlphaTo = true;
			m_alphaTarget = 0;
			GetGameLogic->GetMessageDispatcher()->SendMsg(C_MESSAGE_KILL_ENTITY, 300, this);
			break;
	}

	Entity::OnMessage(msg);
}

void Fly::Update(float step)
{
	Entity::Update(step);

	//are we dead?

	if (m_mode == eWaiting)
	{
		if (TouchingPlayer())
		{
			GetGameLogic->m_fliesKilled++;
           GetGameLogic->GetMessageDispatcher()->SendMsg(C_MESSAGE_SOUND, 0, NULL, C_SOUND_SQUISH);

			SetDeleteFlag(true);
		}
	}

}