
#pragma once

#include <ClanLib/core.h>
#include <ClanLib/application.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h> 
#include <ClanLib/sound.h>

#include <cassert>

using namespace std;

enum
{
      C_FONT_MAIN,
      C_FONT_COUNT
};

//misc helping stuff

#ifndef SAFE_DELETE
#define SAFE_DELETE(p)      { if(p) { delete (p); (p)=NULL; } }
#endif

#ifndef SAFE_DELETE_ARRAY
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=NULL; } }
#endif

//misc utils I added as I needed

float LerpFloat(float f_origin, float f_target, float f_percent);
void Vector2Truncate(CL_Vector2 &vec, float max);
CL_Vector2 Vector2Perp(CL_Vector2 &vec);
#define	RADTODEG			57.2957795130823208768f									//!< 180.0 / PI, convert radians to degrees
#define	DEGTORAD			0.01745329251994329577f									//!< PI / 180.0, convert degrees to radians

float FRandomRange(float min, float max);
int Random(int num);



class GameLogic;

class App : public CL_ClanApplication
{
public:
    App();
    virtual ~App();
    
    virtual int main(int argc, char **argv);
    CL_ResourceManager * GetResourceManager(){return m_pResourceManager;}
    CL_DisplayWindow * GetMainWindow(){return m_pWindow;}
    CL_Font * GetFont(int font_id){return m_pFonts[font_id];}
    void OnWindowResize(int x, int y);
    CL_Surface * GetBackground() {return m_pBackground;}
    CL_Canvas * GetBackgroundCanvas() { return m_pBackgroundCanvas;}
    HWND GetHWND() {return m_Hwnd;}
    void OnWindowClose();
    float GetDelta(){return m_delta;}
    int GetGameTick() {return CL_System::get_time();} //easy to switch systems later if I use this
    void ClearTimingAfterLongPause(); //so our delta timer etc doesn't get screwed up
    GameLogic * GetGameLogic(){return m_pGameLogic;}
	void SetupBackground(string bg, int x, int y);

private:
    
    void OneTimeDeinit();
    void OneTimeInit();
    void ToggleWindowedMode();
    
    void RenderGuys();
    void UpdateLogic();
    void OnLoseFocus();
    void OnGotFocus();
    void SetupMouseClipping();
    void OnKeyUp(const CL_InputEvent &key);

    CL_ResourceManager * m_pResourceManager;
    CL_ResourceManager * m_pGUIResourceManager;
    CL_DisplayWindow * m_pWindow;
    CL_Font *m_pFonts[C_FONT_COUNT];
    CL_Surface *m_pBackground;
    CL_Canvas *m_pBackgroundCanvas; //attached to the background, gives us an interface to its graphical context
    bool m_bWindowResizeRequest; 
    bool m_bQuit;
    bool m_HaveFocus;
    bool m_bClipCursorWhenFullscreen;
    HWND m_Hwnd; //I can't figure out how to get it from ClanLib so I'll keep my own copy
    CL_DisplayWindowDescription m_WindowDescription;
    GameLogic *m_pGameLogic;
    float m_delta; //averaged delta
    float m_deltaTarget; //what the actual last delta was
    int m_lastFrameTime;
 
};

extern App MyApp;

App * GetApp();

#define GetScreenX (GetApp()->GetMainWindow()->get_width())
#define GetScreenY (GetApp()->GetMainWindow()->get_height())